/*
 * Decompiled with CFR 0.152.
 */
package dev.sepd.sepd_donutwarp;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Sepd_DonutWarp
extends JavaPlugin
implements Listener {
    private File warpsFile;
    private FileConfiguration warpsConfig;
    private final Map<UUID, Location> warpCountdowns = new HashMap<UUID, Location>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.createWarpsConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    private void createWarpsConfig() {
        this.warpsFile = new File(this.getDataFolder(), "warps.yml");
        if (!this.warpsFile.exists()) {
            this.saveResource("warps.yml", false);
        }
        this.warpsConfig = YamlConfiguration.loadConfiguration((File)this.warpsFile);
    }

    private void saveWarps() {
        try {
            this.warpsConfig.save(this.warpsFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void reloadPlugin(Player player) {
        this.reloadConfig();
        this.createWarpsConfig();
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Warp plugin configuration reloaded.");
    }

    private void setWarp(String name, Location loc) {
        this.warpsConfig.set(name + ".world", (Object)loc.getWorld().getName());
        this.warpsConfig.set(name + ".x", (Object)loc.getX());
        this.warpsConfig.set(name + ".y", (Object)loc.getY());
        this.warpsConfig.set(name + ".z", (Object)loc.getZ());
        this.warpsConfig.set(name + ".yaw", (Object)Float.valueOf(loc.getYaw()));
        this.warpsConfig.set(name + ".pitch", (Object)Float.valueOf(loc.getPitch()));
        this.saveWarps();
    }

    private Location getWarp(String name) {
        if (!this.warpsConfig.contains(name)) {
            return null;
        }
        World world = Bukkit.getWorld((String)this.warpsConfig.getString(name + ".world"));
        double x = this.warpsConfig.getDouble(name + ".x");
        double y = this.warpsConfig.getDouble(name + ".y");
        double z = this.warpsConfig.getDouble(name + ".z");
        float yaw = (float)this.warpsConfig.getDouble(name + ".yaw");
        float pitch = (float)this.warpsConfig.getDouble(name + ".pitch");
        return new Location(world, x, y, z, yaw, pitch);
    }

    private void sendMsg(Player player, String path, Map<String, String> placeholders) {
        String msg = this.getConfig().getString("messages." + path);
        if (msg == null) {
            return;
        }
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            msg = msg.replace("%" + entry.getKey() + "%", entry.getValue());
        }
        msg = ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
        if (this.getConfig().getBoolean("messages-action-bar")) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(msg));
        }
        if (this.getConfig().getBoolean("messages-chat")) {
            player.sendMessage(msg);
        }
    }

    private void startWarpCountdown(final Player player, final Location loc, final String warpName) {
        final UUID uuid = player.getUniqueId();
        this.warpCountdowns.put(uuid, player.getLocation());
        final int countdown = this.getConfig().getInt("teleport_countdown", 5);
        new BukkitRunnable(){
            int seconds;
            {
                this.seconds = countdown;
            }

            public void run() {
                if (!Sepd_DonutWarp.this.warpCountdowns.containsKey(uuid)) {
                    this.cancel();
                    return;
                }
                Location original = Sepd_DonutWarp.this.warpCountdowns.get(uuid);
                if (original.distanceSquared(player.getLocation()) > 1.0) {
                    Sepd_DonutWarp.this.sendMsg(player, "teleport_cancelled_movement", Map.of());
                    Sepd_DonutWarp.this.warpCountdowns.remove(uuid);
                    this.cancel();
                    return;
                }
                if (this.seconds == 0) {
                    Sepd_DonutWarp.this.warpCountdowns.remove(uuid);
                    player.teleport(loc);
                    Sepd_DonutWarp.this.sendMsg(player, "teleported_to_warp", Map.of("warp", warpName));
                    this.cancel();
                    return;
                }
                Sepd_DonutWarp.this.sendMsg(player, "teleport_countdown", Map.of("seconds", String.valueOf(this.seconds)));
                --this.seconds;
            }
        }.runTaskTimer((Plugin)this, 0L, 20L);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.warpCountdowns.remove(event.getPlayer().getUniqueId());
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        switch (command.getName().toLowerCase()) {
            case "setwarp": {
                if (args.length != 1) {
                    this.sendMsg(player, "setwarp_usage", Map.of());
                    return true;
                }
                String name = args[0];
                if (this.warpsConfig.contains(name)) {
                    this.sendMsg(player, "warp_already_exists", Map.of("warp", name));
                    return true;
                }
                this.setWarp(name, player.getLocation());
                this.sendMsg(player, "warp_set", Map.of("warp", name));
                return true;
            }
            case "delwarp": {
                if (args.length != 1) {
                    this.sendMsg(player, "delwarp_usage", Map.of());
                    return true;
                }
                String name = args[0];
                if (!this.warpsConfig.contains(name)) {
                    this.sendMsg(player, "warp_not_found", Map.of("warp", name));
                    return true;
                }
                this.warpsConfig.set(name, null);
                this.saveWarps();
                this.sendMsg(player, "warp_deleted", Map.of("warp", name));
                return true;
            }
            case "warp": {
                if (args.length != 1) {
                    this.sendMsg(player, "warp_usage", Map.of());
                    return true;
                }
                String name = args[0];
                if (!player.isOp() && !player.hasPermission("warp.use." + name)) {
                    this.sendMsg(player, "no_permission", Map.of());
                    return true;
                }
                Location warpLoc = this.getWarp(name);
                if (warpLoc == null) {
                    this.sendMsg(player, "warp_not_found", Map.of("warp", name));
                    return true;
                }
                this.startWarpCountdown(player, warpLoc, name);
                return true;
            }
            case "warps": {
                player.sendMessage(String.valueOf(ChatColor.GOLD) + "Available warps:");
                for (String warp : this.warpsConfig.getKeys(false)) {
                    if (!player.isOp() && !player.hasPermission("warp.use." + warp)) continue;
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "- " + warp);
                }
                return true;
            }
            case "warpreload": {
                if (!player.isOp() && !player.hasPermission("warp.reload")) {
                    this.sendMsg(player, "no_permission", Map.of());
                    return true;
                }
                this.reloadPlugin(player);
                return true;
            }
        }
        return false;
    }
}

